/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.intervals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalsSource;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;

class FixedFieldIntervalsSource
extends IntervalsSource {
    private final String field;
    private final IntervalsSource source;

    FixedFieldIntervalsSource(String field, IntervalsSource source) {
        this.field = field;
        this.source = source;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        return this.source.intervals(this.field, ctx);
    }

    @Override
    public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        return this.source.matches(this.field, ctx, doc);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        this.source.visit(this.field, visitor);
    }

    @Override
    public int minExtent() {
        return this.source.minExtent();
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        Collection<IntervalsSource> inner = this.source.pullUpDisjunctions();
        if (inner.size() == 1) {
            return Collections.singleton(this);
        }
        return inner.stream().map(s -> new FixedFieldIntervalsSource(this.field, (IntervalsSource)s)).collect(Collectors.toSet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedFieldIntervalsSource that = (FixedFieldIntervalsSource)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.source);
    }

    @Override
    public String toString() {
        return "FIELD(" + this.field + "," + String.valueOf(this.source) + ")";
    }
}

